if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)

local portal_in = resize.location.portal_in
local portal_out = resize.location.portal_out

local allowed_simple = {
  PlayerInteraction.cancel,
  PlayerInteraction.destroy,
  PlayerInteraction.delete,
  PlayerInteraction.pause,
  PlayerInteraction.stop,
  PlayerInteraction.speed_up,
  PlayerInteraction.slow_down,
  PlayerInteraction.undo,
  PlayerInteraction.toggle_menu
}
function main_filter(i)
  if i.type == "MouseEventAction" then
    return i.event == MouseEventAction.lmb_click or i.event == MouseEventAction.rmb_click or i.event == MouseEventAction.lmb_double_click or i.event == MouseEventAction.rmb_double_click
  elseif i.type == "MouseUpdateAction" or i.type == "JoinAction" or i.type == "PlaceBlockAction" then
    return true
  else
    for _, v in pairs(allowed_simple) do
      if i == v then
        return true
      end
    end
    return false
  end
end
set_user_input_filter(main_filter)
local default_vertical = 0.2;
set_default_vertical(default_vertical)
function tutorial_routine()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    state:suppress_toolbar_menu();
    state:suppress_transport_menu();
    state:suppress_interface_hints();
    embed(ramp(4, do_all(
      announce_lambda("These are portals.", 0.1),
      bouncing_arrow_at_game_lambda(portal_in, 0.06, DOWN),
      bouncing_arrow_at_game_lambda(portal_out, 0.06, UP)
    ), captured_cancel()))
    embed(pause(0.25))
    embed(ramp(4, do_all(
      announce_lambda("Anything that goes in here.", 0.07),
      bouncing_arrow_at_game_lambda(portal_in, 0.06, DOWN)
    ), captured_cancel()))
    embed(pause(0.25))
    embed(ramp(4, do_all(
      announce_lambda("Comes out here.", 0.07),
      bouncing_arrow_at_game_lambda(portal_out, 0.06, UP)
    ), captured_cancel()))
    embed(pause(0.25))
    embed(announce("You're on your own for this factory.", 4, 0.06, captured_cancel()))
    state:suppress_toolbar_menu(false);
    embed(pause(0.25))
    embed(ramp(4, do_all(
      announce_lambda("Use the delete tool if you mess up", 0.06),
      announce_lambda("(Or press Z to undo)", 0.04, default_vertical - 0.06),
      highlight_menu_item_lambda("toolbar_0")
    ), captured_cancel()))
    state:suppress_transport_menu(false);
    set_user_input_filter(main_filter)
    embed(pause(0.25))
    embed(announce("Good luck!", 3, 0.15, captured_cancel()))
  end)
end
if not played_in_past then
  draw_interpreted_routine(tutorial_routine())
end

state:filter_interactions(function(i)
  if i.type == "Destroy" then
    if portal_in:contains(i.where) then
      return "Cannot delete the portals."
    elseif portal_out:contains(i.where) then
      return "Cannot delete the portals."
    end
  end
end)
